package cx.threeg.dcms.core;

import android.content.Context;

public class Prefs {
    private static final String NAME = "dcms_prefs";

    private static final String K_KEYWORDS = "keywords";
    private static final String K_READER = "reader_mode";
    private static final String K_THUMB = "show_thumbs";
    private static final String K_TYPO = "enhanced_typo";
    private static final String K_INPUT = "enable_input";

    // 新增常量
    private static final String K_NATIVE = "use_native_layout";
    private static final String K_PREF_JSOUP = "prefer_jsoup";

    public static void setKeywords(Context c, String s) {
        c.getSharedPreferences(NAME, 0).edit().putString(K_KEYWORDS, s).apply();
    }
    public static String getKeywordsRaw(Context c) {
        return c.getSharedPreferences(NAME, 0).getString(K_KEYWORDS, "");
    }
    public static String[] getKeywords(Context c) {
        String ks = getKeywordsRaw(c);
        if (ks == null || ks.trim().length() == 0) return new String[0];
        String[] arr = ks.split(",");
        for (int i = 0; i < arr.length; i++) {
            arr[i] = arr[i].trim();
        }
        return arr;
    }

    public static void setReaderMode(Context c, boolean v) {
        c.getSharedPreferences(NAME, 0).edit().putBoolean(K_READER, v).apply();
    }
    public static boolean isReaderMode(Context c) {
        return c.getSharedPreferences(NAME, 0).getBoolean(K_READER, true);
    }

    public static void setShowThumb(Context c, boolean v) {
        c.getSharedPreferences(NAME, 0).edit().putBoolean(K_THUMB, v).apply();
    }
    public static boolean showThumb(Context c) {
        return c.getSharedPreferences(NAME, 0).getBoolean(K_THUMB, true);
    }

    public static void setEnhancedTypo(Context c, boolean v) {
        c.getSharedPreferences(NAME, 0).edit().putBoolean(K_TYPO, v).apply();
    }
    public static boolean enhancedTypo(Context c) {
        return c.getSharedPreferences(NAME, 0).getBoolean(K_TYPO, true);
    }

    public static void setEnableInput(Context c, boolean v) {
        c.getSharedPreferences(NAME, 0).edit().putBoolean(K_INPUT, v).apply();
    }
    public static boolean enableInput(Context c) {
        return c.getSharedPreferences(NAME, 0).getBoolean(K_INPUT, true);
    }

    // 关于是否使用原生排版（SettingsFragment 里有用）
    public static void setUseNativeLayout(Context c, boolean v) {
        c.getSharedPreferences(NAME, 0).edit().putBoolean(K_NATIVE, v).apply();
    }
    public static boolean useNativeLayout(Context c) {
        return c.getSharedPreferences(NAME, 0).getBoolean(K_NATIVE, false);
    }

    // 关于 preferJsoup（HomeFragment 里读取）
    public static void setPreferJsoup(Context c, boolean v) {
        c.getSharedPreferences(NAME, 0).edit().putBoolean(K_PREF_JSOUP, v).apply();
    }
    public static boolean preferJsoup(Context c) {
        return c.getSharedPreferences(NAME, 0).getBoolean(K_PREF_JSOUP, false);
    }
}